/**
 * Represents a School
 */
export class School{
    /**
     * Represents a School
     * @param {string} name This school's name
     * @param {Array<SchoolSubject>} perfil This school's perfil
     */
    constructor(name, perfil){
        /**
         * @type {string}
         * @description This school's name
         */
        this.name = name;
        /**
         * @type {Array<Subject>}
         * @description This school's perfil
         */
        this.perfil = perfil;
        /**
         * @type {Array<Human>}
         * @description Personal working at school
         */
        this.personal = [];
        /**
         * @type {Array<Teacher>}
         * @description Teachers working at school
         */
        this.teachers = [];
        /**
         * @type {Array<Student>}
         * @description Students learning at school
         */
        this.students = [];
        /**
         * @type {Human}
         * @description The headmaster of the school
         */
        this.headmaster = [];
        /**
         * @type {Array<SchoolClass>}
         * @description The classes at school
         */
        this.classes = [];
        this.oldStudents = [];
        this.oldPersonal = [];
    };
    /**
     * @type {Array<School>}
     * @description List with all schools registered
     */
    static schools = []
    /**
     * Registers this school, making it able to be found using School.lookForSchool()
     * @returns {void}
     */
    registerSchool(){
        for(let s = 0; s < School.schools.length; s++){ if(School.schools[s].name == this.name){ report("School with name:"+this.name+", is already registered!"); return; }; };
        School.schools.push(this); report("Neew school with name: "+this.name);
    };
    /**
     * Looks for a registerd school
     * @param {string} name The school's name to look for
     * @returns {School|undefined}
     */
    static lookForSchool(name){
        for(let s = 0; s < School.schools.length; s++){ if(School.schools[s].name == name){ return School.schools[s]; }; };
        report("School with name: "+name+", not found! Either not registered or wrong name value!");
        return undefined;
    };
    /**
     * Registers a SchoolClass at this school
     * @param {SchoolClass} schoolClass 
     * @returns {number|undefined} The schoolClassIdentifier of the class at this school
     */
    registerClass(schoolClass){
        for(let cl = 0; cl < this.classes.length; cl++){ if(this.classes[cl].identifier == schoolClass.identifier){ report("SchoolClass with identifier: "+schoolClass.identifier+", already in school!"); return undefined; }; };
        schoolClass.schoolClassIdentifier = this.classes.length; this.classes.push(schoolClass); 
        return schoolClass.schoolClassIdentifier;
    };
    /**
     * Adds Students into this school and into a class
     * @param {Array<Student>} students List of Students that want to join this school
     * @param {string|number} classes Class for the students to join; 'Random_' will make the students join random School Classes
     */
    addStudents(students, classes){
        /**
         * @type {Array<Student>}
         */
        let denied = [];
        for(let i = 0; i<students.length; i++){
            for(let s = 0; s<this.students.length; s++){ if(this.students[s].identifier==students[i].identifier){ report(`Student with Id ${students[i].identifier} denied`); denied.push(students[i]); }; };
            if(!denied.includes(students[i])){ if(classes == "Random_"){ let clas = Math.round(Math.random()*this.classes.length%this.classes.length); this.classes[clas].newStudents([students[i]]); report("Student joined class Id"+clas); }else { this.classes[classes].newStudents([students[i]]); report(`Student joined given class: ${classes}`); } };
        };
    };
    /**
     * Searches this school for a Student with a given Id
     * @param {string|number} id The Id of a Student to look for
     * @returns {Object|void}
     */
    lookForStudent(id){
        if(!Human.lookForHuman(id)){report("Human does not exist!"); return;}
        if(!this.students.includes(Human.lookForHuman(id))){report("Student not in this School!"); return;};
        for(let clas = 0; clas < this.classes.length; clas++){ if(this.classes[clas].students.includes(Human.lookForHuman(id))){ for(let s = 0; s < this.classes[clas].students.length; s++){ if(this.classes[clas].students[s].identifier==id){ return {foundStudent: this.classes[clas].students[s], inClass: this.classes[clas]}; } } } };
        report("Student not found in any class!");
        return; 
    };
    /**
     * Removes a Student from the entire school
     * @param {string|number} id The Id of the student to expulse 
     */
    expulseStudent(id){
        if(!Human.lookForHuman(id)){report("Human does not exist!"); return;}
        if(!this.students.includes(Human.lookForHuman(id))){report("Student not in this School!"); return;};
        for(let clas = 0; clas < this.classes.length; clas++){ if(this.classes[clas].students.includes(Human.lookForHuman(id))){ for(let s = 0; s < this.classes[clas].students.length; s++){ if(this.classes[clas].students[s].identifier==id){this.classes[clas].students.splice(s, 1) ;return;} } } };
        report("Student not found in any class!");
        return;
    };
    /**
     * Updates the School's students and personal Objects
     */
    static updateOld(){
        for(let s = 0; School.schools.length; s++){
            report(JSON.stringify({...School.schools[s]}));
            for(let personal = 0; personal<School.schools[s].oldPersonal.length; personal++){
                if(Human.lookForHuman(School.schools[s].oldPersonal[personal]) == undefined){
                    continue;
                }else {
                    School.schools[s].personal.push(Human.lookForHuman(School.schools[s].oldPersonal[personal]));
                    School.schools[s].oldPersonal.splice(personal, 1);
                };
            };
            for(let student = 0; student < School.schools[s].oldStudents.length; student++){
                if(Human.lookForHuman(School.schools[s].oldStudents[student])==undefined){
                    continue;
                }else{
                    School.schools[s].students.push(Human.lookForHuman(School.schools[s].oldStudents[student]));
                    School.schools[s].oldStudents.splice(student, 1);
                };
            }
        }
    }
};